/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.servlet;

import com.fusioncharts.exporter.beans.ExportBean;
import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.ExportParameterNames;
import com.fusioncharts.exporter.beans.FusionChartsExportData;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.error.ErrorHandler;
import com.fusioncharts.exporter.error.LOGMESSAGE;
import com.fusioncharts.exporter.helper.FusionChartsExportHelper;
import com.fusioncharts.exporter.resources.FCExporter_SVG2ALL;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

@WebServlet(value={"/Exporter"})
public class FCExporter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private boolean SAVEFOLDEREXISTS = true;
    private static Logger logger = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ByteArrayOutputStream exportObject;
        System.out.println("PRINTING PARAMETER");
        System.out.println(request);
        FusionChartsExportData exportData = new FusionChartsExportData(request.getParameter("stream"), request.getParameter("stream_type"), request.getParameter("parameters"), request.getParameter("meta_width"), request.getParameter("meta_height"), request.getParameter("meta_DOMId"), request.getParameter("meta_bgColor"), request.getParameter("encodedImgData"));
        ExportBean exportBean = FusionChartsExportHelper.parseExportRequestStream(exportData);
        String exportTargetWindow = (String)exportBean.getExportParameterValue(ExportParameterNames.EXPORTTARGETWINDOW.toString());
        String exportFormat = (String)exportBean.getExportParameterValue(ExportParameterNames.EXPORTFORMAT.toString());
        String exportAction = (String)exportBean.getExportParameterValue(ExportParameterNames.EXPORTACTION.toString());
        String action = request.getParameter("fcserveraction");
        logger.info("action " + action);
        if (action != null && action.equals("save")) {
            exportAction = "save";
            exportBean.addExportParameter(ExportParameterNames.EXPORTACTION.toString(), exportAction);
        }
        LogMessageSetVO logMessageSetVO = exportBean.validate();
        Set<LOGMESSAGE> errorsSet = logMessageSetVO.getErrorsSet();
        boolean isHTML = exportBean.isHTMLResponse();
        if (errorsSet != null && !errorsSet.isEmpty()) {
            String meta_values = exportBean.getMetadataAsQueryString(null, true, isHTML);
            logMessageSetVO.setOtherMessages(meta_values);
            this.writeError(response, isHTML, logMessageSetVO, exportTargetWindow);
            return;
        }
        if (!exportAction.equals("download")) {
            if (!this.SAVEFOLDEREXISTS) {
                logMessageSetVO.addError(LOGMESSAGE.E508);
                String meta_values = exportBean.getMetadataAsQueryString(null, true, isHTML);
                logMessageSetVO.setOtherMessages(meta_values);
                this.writeError(response, isHTML, logMessageSetVO, exportTargetWindow);
                return;
            }
            String fileNameWithoutExt = (String)exportBean.getExportParameterValue(ExportParameterNames.EXPORTFILENAME.toString());
            String extension = FusionChartsExportHelper.getExtensionFor(exportFormat.toLowerCase());
            String fileName = fileNameWithoutExt + "." + extension;
            logMessageSetVO = ErrorHandler.checkServerSaveStatus(fileName);
            errorsSet = logMessageSetVO.getErrorsSet();
        }
        if (errorsSet != null && !errorsSet.isEmpty()) {
            String meta_values = exportBean.getMetadataAsQueryString(null, true, isHTML);
            logMessageSetVO.setOtherMessages(meta_values);
            this.writeError(response, isHTML, logMessageSetVO, exportTargetWindow);
            return;
        }
        FCExporter_SVG2ALL fcExporter = new FCExporter_SVG2ALL(this.getServletContext().getRealPath("/"), exportBean);
        if (exportData.getStream_type().equals("IMAGE-DATA")) {
            String base64ImageData = exportData.getStream().split(",")[1];
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(base64ImageData);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(imageByte.length);
            bos.write(imageByte, 0, imageByte.length);
            exportObject = bos;
        } else {
            exportObject = fcExporter.exportProcessor(response);
        }
        if (exportObject != null) {
            String status = fcExporter.exportOutput(exportObject, response);
            if (status == null) {
                System.out.println("failure in exporting");
            } else {
                System.out.println("Exporting successful");
            }
        } else {
            System.out.println("Error in Export Processor");
        }
    }

    private void writeError(HttpServletResponse response, boolean isHTML, LogMessageSetVO logMessageSetVO, String exportTargetWindow) {
        response.setContentType("text/html");
        if (exportTargetWindow != null && exportTargetWindow.equalsIgnoreCase("_self")) {
            response.addHeader("Content-Disposition", "attachment;");
        } else {
            response.addHeader("Content-Disposition", "inline;");
        }
        try {
            PrintWriter out = response.getWriter();
            out.print(ErrorHandler.buildResponse(logMessageSetVO, isHTML));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info("FCExporter Servlet Init called");
        ExportConfiguration.loadProperties();
        File f = new File(ExportConfiguration.SAVEPATH);
        boolean savePathAbsolute = f.isAbsolute();
        logger.info("Is SAVEPATH on server absolute?" + savePathAbsolute);
        String realPath = config.getServletContext().getRealPath(ExportConfiguration.SAVEPATH);
        if (realPath == null) {
            logger.log(Level.SEVERE, "For this environment, SAVEPATH should be absolute");
            realPath = "";
        }
        ExportConfiguration.SAVEABSOLUTEPATH = savePathAbsolute ? ExportConfiguration.SAVEPATH : realPath;
        this.SAVEFOLDEREXISTS = ErrorHandler.doesServerSaveFolderExist();
        if (!this.SAVEFOLDEREXISTS) {
            logger.warning(LOGMESSAGE.E508.toString() + "Path used: " + ExportConfiguration.SAVEABSOLUTEPATH);
        }
    }

    static {
        logger = Logger.getLogger(FCExporter.class.getName());
    }
}

