function layoutControl(offsetX) {
    const thresholdX = offsetX ? offsetX : 16;
    const menubar_vertical = document.querySelector('.ae-menubar.menubar[aria-orientation="vertical"]');
    const toolbar = document.querySelector('.ae-menubar.toolbar');
    const switch_menu_pos_button = document.getElementById('switch-menu-position');
    const sc_main_content = document.getElementById('sc-main-content');
    const checkRTL = menubar_vertical.classList.contains('is-rtl');

    sc_main_content.parentElement.style.height = '100%';

    if(checkRTL) {
      if(window.getComputedStyle(menubar_vertical).left !== 'auto') {
        menubar_vertical.style.right = '0';
        menubar_vertical.style.left = 'auto';
      }
    }

    const addPadding = () => {
      if(checkRTL) {
        sc_main_content.style.paddingRight = menubar_vertical.offsetWidth + thresholdX + 'px';
        
        if(toolbar) {          
          setTimeout(() => {          
            toolbar.style.width = sc_main_content.offsetWidth - menubar_vertical.offsetWidth - thresholdX - 16 + 'px';
          }, 251)
        }

      } else {
        sc_main_content.style.paddingLeft = menubar_vertical.offsetWidth + thresholdX + 'px';
      }
    }

    // init
    addPadding();

    // click
    switch_menu_pos_button.addEventListener('click', () => {
      setTimeout(addPadding, 250);
    });
  } 