SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Sequence structure for "public"."company_companyid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS company_companyid_seq;
CREATE SEQUENCE company_companyid_seq START WITH 6 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."contacts_contactid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS contacts_contactid_seq;
CREATE SEQUENCE contacts_contactid_seq START WITH 7 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."department_departmentid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS department_departmentid_seq;
CREATE SEQUENCE department_departmentid_seq START WITH 8 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."documenthistoryid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS documenthistoryid_seq;
CREATE SEQUENCE documenthistoryid_seq START WITH 7 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."documentlibraryid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS documentlibraryid_seq;
CREATE SEQUENCE documentlibraryid_seq START WITH 2 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."issues_issueid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS issues_issueid_seq;
CREATE SEQUENCE issues_issueid_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."projects_projectid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS projects_projectid_seq;
CREATE SEQUENCE projects_projectid_seq START WITH 15 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."resources_resourceid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS resources_resourceid_seq;
CREATE SEQUENCE resources_resourceid_seq START WITH 5 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."tasks_taskid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS tasks_taskid_seq;
CREATE SEQUENCE tasks_taskid_seq START WITH 22 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."timecard_timecardid_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS timecard_timecardid_seq;
CREATE SEQUENCE timecard_timecardid_seq START WITH 18 INCREMENT BY 1;

-- ----------------------------
-- Table structure for `Company`
-- ----------------------------

create table `company` (
  `companyid` int(11) not null auto_increment,
  `fld_name` varchar(200) default null,
  primary key (`companyid`)
) engine=innodb auto_increment=6 default charset=utf8;

-- ----------------------------
-- Records of Company
-- ----------------------------
INSERT INTO `company` VALUES ('1', 'Large Bank and Trust'), ('2', 'Sample Co'), ('3', 'Healthy Care'), ('4', 'Aircrafts Inc'), ('5', 'Acme Technology');


-- ----------------------------
-- Table structure for `contacts`
-- ----------------------------

create table `contacts` (
  `contactid` int(11) not null auto_increment,
  `fld_name` varchar(200) not null default '',
  `company` int(11) default null,
  `title` varchar(200) default null,
  `department` int(11) default null,
  `phone` varchar(30) default null,
  `mobile` varchar(30) default null,
  `fax` varchar(30) default null,
  `email` varchar(200) default null,
  `recordowner` int(11) default null,
  `lastmodifyby` int(11) default null,
  primary key (`contactid`)
) engine=innodb auto_increment=7 default charset=utf8;

-- ----------------------------
-- Records of Contacts
-- ----------------------------
INSERT INTO `contacts` VALUES ('1', 'Lisa Jones', '1', 'Finance Director', '1', '6175554567', '', '', 'jones@example.com', '1', '1'), ('2', 'John Hunh', '1', 'Vp Special Proejcts', '2', '8132208977', '', '', 'hunh@example.com', '1', '1'), ('3', 'Linda Rice', '2', 'VP Customer Service', '3', '6175559874', '', '', 'rice@example.com', '1', '1'), ('4', 'Susan Campbell', '3', 'IT Manager', '4', '6175552345', '888888888', '', 'campbell@example.com', '3', '3'), ('5', 'Marshall Azar', '4', 'Development Manager', '2', '6175551234', '', '', 'asar@example.com', '3', '3'), ('6', 'Alan White', '5', 'Marketing Director', '6', '6175551111', '', '', 'white@example.com', '3', '3');

-- ----------------------------
-- Table structure for `Department`
-- ----------------------------

create table `department` (
  `departmentid` int(11) not null auto_increment,
  `fld_name` varchar(200) default null,
  primary key (`departmentid`)
) engine=innodb auto_increment=8 default charset=utf8;

-- ----------------------------
-- Records of Department
-- ----------------------------
INSERT INTO `department` VALUES ('1', 'Finance'), ('2', 'Engineering'), ('3', 'Operations'), ('4', 'Information Technology'), ('5', 'QA'), ('6', 'Marketing'), ('7', 'Management');


-- ----------------------------
-- Table structure for `DocumentHistory`
-- ----------------------------

create table `documenthistory` (
  `documenthistoryid` int(11) not null auto_increment,
  `documentlibraryid` int(11) not null,
  `revision` int(11) default null,
  `datecreated` date default null,
  `fileformat` varchar(100) default null,
  `attachment` blob,
  `recordowner` int(11) default null,
  `documentcurrent` char(1) default null,
  primary key (`documenthistoryid`),
  key `documentlibraryid` (`documentlibraryid`),
  constraint `documenthistory_ibfk_1` foreign key (`documentlibraryid`) references `documentlibrary` (`documentlibraryid`)
) engine=innodb auto_increment=7 default charset=utf8;

-- ----------------------------
-- Records of DocumentHistory
-- ----------------------------
INSERT INTO `documenthistory` VALUES ('4', '2', '1', '2010-02-24', 'samples.txt', 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
INSERT INTO `documenthistory` VALUES ('5', '2', '2', '2010-02-24', 'samples.txt', '', '2', 'N');
INSERT INTO `documenthistory` VALUES ('6', '2', '3', '2011-11-28', 'samples.txt', '', '1', 'Y');

-- ----------------------------
-- Table structure for `DocumentLibrary`
-- ----------------------------

create table `documentlibrary` (
  `documentlibraryid` int(11) not null auto_increment,
  `projectid` int(11) default null,
  `title` varchar(200) default null,
  `description` text,
  `attachment` blob,
  `filetype` varchar(30) default null,
  `fileformat` varchar(100) default null,
  `datecreated` date default null,
  `datemodified` date default null,
  `recordowner` int(11) default null,
  `lastmodifiedby` int(11) default null,
  primary key (`documentlibraryid`),
  key `projectid` (`projectid`),
  constraint `documentlibrary_ibfk_1` foreign key (`projectid`) references `projects` (`projectid`)
) engine=innodb auto_increment=3 default charset=utf8;

-- ----------------------------
-- Records of DocumentLibrary
-- ----------------------------
INSERT INTO `documentlibrary` VALUES ('2', '6', 'Project MER', 'testing!', 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, 'SPECIFICATION', 'samples.txt', '2010-02-24', '2012-05-11', '2', '2');

-- ----------------------------
-- Table structure for `FileType`
-- ----------------------------

create table `filetype` (
  `filetypeid` varchar(30) not null,
  `description` varchar(200) default null,
  primary key (`filetypeid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of FileType
-- ----------------------------
INSERT INTO `filetype` VALUES ('BUDGET', 'Budget'), ('COPY', 'Copy'), ('MARKETING-DOCUMENT', 'Marketing Document'), ('REQUIREMENTS', 'Requirements'), ('SPECIFICATION', 'Specification');


-- ----------------------------
-- Table structure for `IssuePriority`
-- ----------------------------

create table `issuepriority` (
  `priorityid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`priorityid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of IssuePriority
-- ----------------------------
INSERT INTO `issuepriority` VALUES ('HIGH', 'High'), ('LOW', 'Low'), ('MEDIUM', 'Medium');


-- ----------------------------
-- Table structure for `Issues`
-- ----------------------------

create table `issues` (
  `issueid` int(11) not null auto_increment,
  `issuename` varchar(200) default null,
  `description` text,
  `assignedto` int(11) default null,
  `duedate` date default null,
  `issuestatus` varchar(100) default null,
  `projectid` int(11) default null,
  `updates` text,
  `resolution` text,
  `issuepriority` varchar(100) default null,
  `dateidentified` date default null,
  `daysoverdue` int(11) default null,
  `dateresolved` date default null,
  `datecreated` date default null,
  `datemodified` date default null,
  `recordowner` int(11) default null,
  `lastmodifiedby` int(11) default null,
  primary key (`issueid`),
  key `projectid` (`projectid`),
  key `issuestatus` (`issuestatus`),
  key `issuepriority` (`issuepriority`),
  constraint `issues_ibfk_1` foreign key (`issuestatus`) references `issuestatus` (`statusid`),
  constraint `issues_ibfk_2` foreign key (`projectid`) references `projects` (`projectid`),
  constraint `issues_ibfk_3` foreign key (`issuepriority`) references `issuepriority` (`priorityid`)
) engine=innodb auto_increment=4 default charset=utf8;

-- ----------------------------
-- Records of Issues
-- ----------------------------
INSERT INTO `issues` VALUES ('1', 'Security audit problems', 'The proposed network topology did not pass the scrutiny of the security team we need to add more layers of protection to the original design', '3', '2008-11-14', 'CLOSED', '6', '', 'Added layerts of protection and tested.', 'HIGH', '2008-11-07', '1109', '2011-11-28', '2009-08-04', '2011-11-28', '2', '2'), ('2', 'Significant usability feedback ', 'The usability feedback indicates major problems with fundamental design. We need to go back to the drawing board.', '4', '2009-01-06', 'OPEN', '8', '', '', 'HIGH', '2008-11-29', '210', null, '2009-08-04', '2009-08-04', '2', '2'), ('3', 'ROI model is flawed ', 'The ROI model that was created for the project is flawed. It underestimates the amount of end users visiting the site therefore the cost per client is too low. We need to revise and send back to the client', '1', '2008-11-17', 'OPEN', '9', '[FEB-11-03 QuickBase] Found last years site visits', 'Found actual visits for last year and created an up to date forecast.', 'LOW', '2008-11-15', '260', null, '2009-08-04', '2009-08-04', '2', '2');

-- ----------------------------
-- Table structure for `IssueStatus`
-- ----------------------------

create table `issuestatus` (
  `statusid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`statusid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of IssueStatus
-- ----------------------------
INSERT INTO `issuestatus` VALUES ('CLOSED', 'Closed');
INSERT INTO `issuestatus` VALUES ('OPEN', 'Open');

-- ----------------------------
-- Table structure for `lookup`
-- ----------------------------

create table `lookup` (
  `code` varchar(100) not null default '',
  `xkey` varchar(100) not null default '',
  `description` varchar(200) default null,
  `pm_type` varchar(100) default null,
  primary key (`code`,`xkey`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of Lookup
-- ----------------------------
INSERT INTO `lookup` VALUES ('companyid', 'company', 'companyid', 'int'), ('fld_name', 'company', 'fld_name', 'varchar'), ('contactid', 'contacts', 'contactid', 'int'), ('fld_name', 'contacts', 'fld_name', 'varchar'), ('company', 'contacts', 'company', 'int'), ('title', 'contacts', 'title', 'varchar'), ('department', 'contacts', 'department', 'int'), ('phone', 'contacts', 'phone', 'varchar'), ('mobile', 'contacts', 'mobile', 'varchar'), ('fax', 'contacts', 'fax', 'varchar'), ('email', 'contacts', 'email', 'varchar'), ('recordowner', 'contacts', 'recordowner', 'int'), ('lastmodifyby', 'contacts', 'lastmodifyby', 'int'), ('departmentid', 'department', 'departmentid', 'int'), ('fld_name', 'department', 'fld_name', 'varchar'), ('documenthistoryid', 'documenthistory', 'documenthistoryid', 'int'), ('documentlibraryid', 'documenthistory', 'documentlibraryid', 'int'), ('revision', 'documenthistory', 'revision', 'int'), ('datecreated', 'documenthistory', 'datecreated', 'date'), ('fileformat', 'documenthistory', 'fileformat', 'varchar'), ('attachment', 'documenthistory', 'attachment', 'blob'), ('recordowner', 'documenthistory', 'recordowner', 'int'), ('documentcurrent', 'documenthistory', 'documentcurrent', 'char'), ('documentlibraryid', 'documentlibrary', 'documentlibraryid', 'int'), ('projectid', 'documentlibrary', 'projectid', 'int'), ('title', 'documentlibrary', 'title', 'varchar'), ('description', 'documentlibrary', 'description', 'text'), ('attachment', 'documentlibrary', 'attachment', 'blob'), ('filetype', 'documentlibrary', 'filetype', 'varchar'), ('fileformat', 'documentlibrary', 'fileformat', 'varchar'), ('datecreated', 'documentlibrary', 'datecreated', 'date'), ('datemodified', 'documentlibrary', 'datemodified', 'date'), ('recordowner', 'documentlibrary', 'recordowner', 'int'), ('lastmodifiedby', 'documentlibrary', 'lastmodifiedby', 'int'), ('filetypeid', 'filetype', 'filetypeid', 'varchar'), ('description', 'filetype', 'description', 'varchar'), ('priorityid', 'issuepriority', 'priorityid', 'varchar'), ('description', 'issuepriority', 'description', 'varchar'), ('issueid', 'issues', 'issueid', 'int'), ('issuename', 'issues', 'issuename', 'varchar'), ('description', 'issues', 'description', 'text'), ('assignedto', 'issues', 'assignedto', 'int'), ('duedate', 'issues', 'duedate', 'date'), ('issuestatus', 'issues', 'issuestatus', 'varchar'), ('projectid', 'issues', 'projectid', 'int'), ('updates', 'issues', 'updates', 'text'), ('resolution', 'issues', 'resolution', 'text'), ('issuepriority', 'issues', 'issuepriority', 'varchar'), ('dateidentified', 'issues', 'dateidentified', 'date'), ('daysoverdue', 'issues', 'daysoverdue', 'int'), ('dateresolved', 'issues', 'dateresolved', 'date'), ('datecreated', 'issues', 'datecreated', 'date'), ('datemodified', 'issues', 'datemodified', 'date'), ('recordowner', 'issues', 'recordowner', 'int'), ('lastmodifiedby', 'issues', 'lastmodifiedby', 'int'), ('statusid', 'issuestatus', 'statusid', 'varchar'), ('description', 'issuestatus', 'description', 'varchar'), ('projectphaseid', 'projectphase', 'projectphaseid', 'varchar'), ('description', 'projectphase', 'description', 'varchar'), ('priorityid', 'projectpriority', 'priorityid', 'varchar'), ('description', 'projectpriority', 'description', 'varchar'), ('projectid', 'projects', 'projectid', 'int'), ('recordowner', 'projects', 'recordowner', 'varchar'), ('projectlead', 'projects', 'projectlead', 'int'), ('lastmodifiedby', 'projects', 'lastmodifiedby', 'int'), ('projectname', 'projects', 'projectname', 'varchar'), ('company', 'projects', 'company', 'int'), ('contactname', 'projects', 'contactname', 'varchar'), ('summary', 'projects', 'summary', 'text'), ('estimatedprojectstart', 'projects', 'estimatedprojectstart', 'date'), ('estimatedprojectend', 'projects', 'estimatedprojectend', 'date'), ('projectpriority', 'projects', 'projectpriority', 'varchar'), ('projectstatus', 'projects', 'projectstatus', 'varchar'), ('notes', 'projects', 'notes', 'text'), ('startdate', 'projects', 'startdate', 'date'), ('plannedfinishdate', 'projects', 'plannedfinishdate', 'date'), ('percentecomplete', 'projects', 'percentecomplete', 'int'), ('customercontact', 'projects', 'customercontact', 'int'), ('actualcost', 'projects', 'actualcost', 'decimal'), ('estimatedcost', 'projects', 'estimatedcost', 'decimal'), ('actualhours', 'projects', 'actualhours', 'int'), ('estimetedhours', 'projects', 'estimetedhours', 'int'), ('percentoverbudget', 'projects', 'percentoverbudget', 'int'), ('datecreated', 'projects', 'datecreated', 'datetime'), ('datemodified', 'projects', 'datemodified', 'datetime'), ('statusid', 'projectstatus', 'statusid', 'varchar'), ('description', 'projectstatus', 'description', 'varchar'), ('resourceid', 'resources', 'resourceid', 'int'), ('fld_name', 'resources', 'fld_name', 'varchar'), ('bussinesphone', 'resources', 'bussinesphone', 'varchar'), ('skillset', 'resources', 'skillset', 'text'), ('rate', 'resources', 'rate', 'decimal'), ('notes', 'resources', 'notes', 'text'), ('jobtitle', 'resources', 'jobtitle', 'varchar'), ('reportsto', 'resources', 'reportsto', 'varchar'), ('departmentid', 'resources', 'departmentid', 'int'), ('companyid', 'resources', 'companyid', 'int'), ('bussinessfax', 'resources', 'bussinessfax', 'varchar'), ('photo', 'resources', 'photo', 'blob'), ('datecreated', 'resources', 'datecreated', 'date'), ('datemodified', 'resources', 'datemodified', 'date'), ('recordowner', 'resources', 'recordowner', 'int'), ('lastmodifiedby', 'resources', 'lastmodifiedby', 'int'), ('login', 'resources', 'login', 'varchar'), ('pwd', 'resources', 'pwd', 'varchar'), ('priorityid', 'taskpriority', 'priorityid', 'varchar'), ('description', 'taskpriority', 'description', 'varchar'), ('taskid', 'tasks', 'taskid', 'int'), ('projectid', 'tasks', 'projectid', 'int'), ('projectphase', 'tasks', 'projectphase', 'varchar'), ('taskname', 'tasks', 'taskname', 'varchar'), ('milestone', 'tasks', 'milestone', 'char'), ('description', 'tasks', 'description', 'text'), ('duration', 'tasks', 'duration', 'int'), ('startdate', 'tasks', 'startdate', 'date'), ('finishdate', 'tasks', 'finishdate', 'date'), ('daysoverdue', 'tasks', 'daysoverdue', 'int'), ('taskstatus', 'tasks', 'taskstatus', 'varchar'), ('percentcomplete', 'tasks', 'percentcomplete', 'int'), ('taskpriority', 'tasks', 'taskpriority', 'varchar'), ('assignedto', 'tasks', 'assignedto', 'int'), ('historynote', 'tasks', 'historynote', 'text'), ('datecreated', 'tasks', 'datecreated', 'date'), ('datemodified', 'tasks', 'datemodified', 'date'), ('recordowner', 'tasks', 'recordowner', 'int'), ('lastmodifiedby', 'tasks', 'lastmodifiedby', 'int'), ('taskpredecessor', 'tasks', 'taskpredecessor', 'varchar'), ('actualfinishdate', 'tasks', 'actualfinishdate', 'date'), ('statusid', 'taskstatus', 'statusid', 'varchar'), ('description', 'taskstatus', 'description', 'varchar'), ('timecardid', 'timecard', 'timecardid', 'int'), ('projectid', 'timecard', 'projectid', 'int'), ('resourceid', 'timecard', 'resourceid', 'int'), ('weekstartingon', 'timecard', 'weekstartingon', 'date'), ('sun', 'timecard', 'sun', 'int'), ('mon', 'timecard', 'mon', 'int'), ('tue', 'timecard', 'tue', 'int'), ('wed', 'timecard', 'wed', 'int'), ('thu', 'timecard', 'thu', 'int'), ('fri', 'timecard', 'fri', 'int'), ('sat', 'timecard', 'sat', 'int'), ('datecreated', 'timecard', 'datecreated', 'date'), ('datemodified', 'timecard', 'datemodified', 'date'), ('recordowner', 'timecard', 'recordowner', 'int'), ('lastmodifiedby', 'timecard', 'lastmodifiedby', 'int');

INSERT INTO `lookup` VALUES ('BEGINNINGWITH', 'CRITERIA', 'Beginning with', 'NUMERIC'), ('BETWEEN', 'CRITERIA', 'Between', 'NUMERIC'), ('DIFFERENT', 'CRITERIA', 'Different', 'NUMERIC'), ('EQUALTO', 'CRITERIA', 'Equal to', 'NUMERIC'), ('GREATEREQUAL', 'CRITERIA', 'Greater Equal', 'NUMERIC'), ('GREATERTHAN', 'CRITERIA', 'Greater than', 'NUMERIC'), ('LESSEQUAL', 'CRITERIA', 'Less Equal', 'NUMERIC'), ('LESSTHAN', 'CRITERIA', 'Less than', 'NUMERIC'), ('NOTNULL', 'CRITERIA', 'Not NULL', 'NUMERIC'), ('NULL', 'CRITERIA', 'NULL', 'NUMERIC'), ('IN', 'CRITERIA', 'In', 'NUMERIC'), ('CONTAINS', 'CRITERIA', 'Contains', 'NUMERIC');

-- ----------------------------
-- Table structure for `ProjectPhase`
-- ----------------------------

create table `projectphase` (
  `projectphaseid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`projectphaseid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ProjectPhase
-- ----------------------------
INSERT INTO `projectphase` VALUES ('DESIGN', 'Design'), ('DEVELOPMENT', 'Development'), ('PLANINNG', 'Planning'), ('TEST', 'Test');


-- ----------------------------
-- Table structure for `ProjectPriority`
-- ----------------------------

create table `projectpriority` (
  `priorityid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`priorityid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ProjectPriority
-- ----------------------------
INSERT INTO `projectpriority` VALUES ('HIGH', 'High'), ('LOW', 'Low'), ('MEDIUM', 'Medium'), ('VERYHIGH', 'Very High');


-- ----------------------------
-- Table structure for `Projects`
-- ----------------------------

create table `projects` (
  `projectid` int(11) not null auto_increment,
  `recordowner` varchar(200) not null default '',
  `projectlead` int(11) not null,
  `lastmodifiedby` int(11) not null,
  `projectname` varchar(255) default null,
  `company` int(11) default null,
  `contactname` varchar(200) default null,
  `summary` text,
  `estimatedprojectstart` date default null,
  `estimatedprojectend` date default null,
  `projectpriority` varchar(100) default null,
  `projectstatus` varchar(100) default null,
  `notes` text,
  `startdate` date default null,
  `plannedfinishdate` date default null,
  `percentecomplete` int(11) default null,
  `customercontact` int(11) default null,
  `actualcost` decimal(20,3) default null,
  `estimatedcost` decimal(20,3) default null,
  `actualhours` int(11) default null,
  `estimetedhours` int(11) default null,
  `percentoverbudget` int(11) default null,
  `datecreated` datetime default null,
  `datemodified` datetime default null,
  primary key (`projectid`),
  key `projectpriority` (`projectpriority`),
  key `projectstatus` (`projectstatus`),
  key `customercontact` (`customercontact`),
  constraint `projects_ibfk_1` foreign key (`projectpriority`) references `projectpriority` (`priorityid`),
  constraint `projects_ibfk_2` foreign key (`projectstatus`) references `projectstatus` (`statusid`)
) engine=innodb auto_increment=15 default charset=utf8;

-- ----------------------------
-- Records of Projects
-- ----------------------------
INSERT INTO `projects` VALUES ('6', '3', '2', '3', 'Employee system update', '2', 'Linda Rice', 'Update and supply new computers to customer service team.  This project will include networking all of these computers to give users the ability to share Oracle databases; internet access; and other multi-tasking functions.', '2008-08-16', null, 'HIGH', 'OPEN', '', '2008-08-16', null, '81', '1', '3520.000', '5000.000', '32', '60', '70', null, null), ('7', '3', '2', '3', 'DBMS system upgrade', '2', 'John Hunh', 'Update with latest release of DBMS and install new financial package', '2007-08-16', '2008-11-11', 'MEDIUM', 'COMPLETED', '', '2007-08-16', '2009-08-04', '100', '2', '5845.000', '15000.000', '63', '200', '38', null, '2011-11-28 17:43:30'), ('8', '3', '4', '3', 'Newsletter System', '2', 'Alan White', 'Refine and expand internet presence for Wireless team through a more sophisticated and interactive web site that will allow individuals to browse available technology', '2008-09-15', '2009-10-20', 'LOW', 'IN-PROGRESS', '', '2008-09-15', null, '66', '3', '2250.000', '4150.000', '30', '50', '54', null, null), ('9', '2', '4', '2', 'Network', '2', 'John Hunh', '', '2008-09-08', null, 'MEDIUM', 'IN-PROGRESS', '', '2008-09-08', null, '42', '4', '0.000', '1500.000', '0', '50', '0', null, null), ('10', '2', '2', '2', 'Project Management training', '2', 'Marshall Azar', 'Install document management system and train engineering staff', '2009-08-01', null, 'MEDIUM', 'OPEN', '', '2009-08-03', null, '50', '5', '6955.000', '8000.000', '91', '100', '86', null, null), ('11', '2', '4', '2', 'New headquarter', '2', 'Susan Campbell', 'Cardinal has seen a tremendous growth for their online services and their local network operations center needs an upgrade from T1 to T3', '2008-11-14', null, 'LOW', 'IN-PROGRESS', '', null, null, '8', '6', '6210.000', '10000.000', '76', '100', '0', null, null), ('12', '2', '1', '2', 'ScriptCase Project Manager v1.0', '2', 'Alan White', 'Finish all the system requirements and prepare a release for it', '2009-09-16', '2009-09-18', 'HIGH', 'IN-PROGRESS', '', '2009-09-16', null, '0', '1', '110.000', '2000.000', '1', '20', '0', null, null);


-- ----------------------------
-- Table structure for `ProjectStatus`
-- ----------------------------

create table `projectstatus` (
  `statusid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`statusid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of ProjectStatus
-- ----------------------------
INSERT INTO `projectstatus` VALUES ('COMPLETED', 'Completed'), ('IN-PROGRESS', 'In-progress'), ('ON-HOLD', 'On-Hold'), ('OPEN', 'Open');


-- ----------------------------
-- Table structure for `Resources`
-- ----------------------------

create table `resources` (
  `resourceid` int(11) not null auto_increment,
  `fld_name` varchar(100) default null,
  `bussinesphone` varchar(30) default null,
  `skillset` text,
  `rate` decimal(20,3) default null,
  `notes` text,
  `jobtitle` varchar(100) default null,
  `reportsto` varchar(100) default null,
  `departmentid` int(11) default null,
  `companyid` int(11) default null,
  `bussinessfax` varchar(30) default null,
  `photo` blob,
  `datecreated` date default null,
  `datemodified` date default null,
  `recordowner` int(11) default null,
  `lastmodifiedby` int(11) default null,
  `login` varchar(255) default null,
  `pwd` varchar(255) default null,
  primary key (`resourceid`),
  key `departmentid` (`departmentid`),
  key `companyid` (`companyid`),
  constraint `resources_ibfk_1` foreign key (`departmentid`) references `department` (`departmentid`),
  constraint `resources_ibfk_2` foreign key (`companyid`) references `company` (`companyid`)
) engine=innodb auto_increment=5 default charset=utf8;

-- ----------------------------
-- Records of Resources
-- ----------------------------
INSERT INTO `resources` VALUES ('1', 'Albert Cruz', '(617) 555-1111', '', '110.000', '', 'Copywriter', '', '6', '2', '(617) 555-1111', '', '2009-07-13', '2011-11-28', '1', '1', 'admin', '21232f297a57a5a743894a0e4a801fc3'), ('2', 'Chris Baker', '(617) 555-2222', '', '90.000', '', 'Project Manager', '', '7', '2', '', '', '2009-07-23', '2011-11-28', '1', '1', 'chris', '21232f297a57a5a743894a0e4a801fc3'), ('3', 'Gregory Baxter', '(617) 555-', '', '80.000', '', 'HTML Editor', '', '6', '2', '', '', '2009-07-23', '2009-08-03', '1', '1', 'gregory', '21232f297a57a5a743894a0e4a801fc3'), ('4', 'Colleen Garton', '(617) 555-', '', '75.000', '', 'Developer', '', '2', '2', '', '', '2009-08-03', '2012-05-11', '3', '3', 'colleen', '21232f297a57a5a743894a0e4a801fc3');

-- ----------------------------
-- Table structure for `TaskPriority`
-- ----------------------------

create table `taskpriority` (
  `priorityid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`priorityid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of TaskPriority
-- ----------------------------
INSERT INTO `taskpriority` VALUES ('HIGH', 'High'), ('LOW', 'Low'), ('MEDIUM', 'Medium'), ('SAMPLE', 'Sample');


-- ----------------------------
-- Table structure for `tasks`
-- ----------------------------

create table `tasks` (
  `taskid` int(11) not null auto_increment,
  `projectid` int(11) default null,
  `projectphase` varchar(100) default null,
  `taskname` varchar(200) default null,
  `milestone` char(1) default null,
  `description` text,
  `duration` int(11) default null,
  `startdate` date default null,
  `finishdate` date default null,
  `daysoverdue` int(11) default null,
  `taskstatus` varchar(100) default null,
  `percentcomplete` int(11) default null,
  `taskpriority` varchar(100) default null,
  `assignedto` int(11) default null,
  `historynote` text,
  `datecreated` date default null,
  `datemodified` date default null,
  `recordowner` int(11) default null,
  `lastmodifiedby` int(11) default null,
  `taskpredecessor` varchar(200) default null,
  `actualfinishdate` date default null,
  primary key (`taskid`),
  key `projectid` (`projectid`),
  key `taskpriority` (`taskpriority`),
  key `taskstatus` (`taskstatus`),
  key `projectphase` (`projectphase`),
  constraint `tasks_ibfk_1` foreign key (`taskstatus`) references `taskstatus` (`statusid`),
  constraint `tasks_ibfk_2` foreign key (`taskpriority`) references `taskpriority` (`priorityid`),
  constraint `tasks_ibfk_3` foreign key (`projectid`) references `projects` (`projectid`),
  constraint `tasks_ibfk_4` foreign key (`projectphase`) references `projectphase` (`projectphaseid`)
) engine=innodb auto_increment=33 default charset=utf8;

-- ----------------------------
-- Records of Tasks
-- ----------------------------
INSERT INTO `tasks` VALUES ('1', '7', 'DEVELOPMENT', 'Upgrade DBMS', 'Y', 'DBMS has new throughput capacity the will increase transaction speed by 30%', '4', '2008-12-06', '2008-12-10', '442', 'COMPLETED', '100', 'HIGH', '2', '', '2009-08-03', '2010-02-25', '0', '1', '', '2010-02-25'), ('2', '7', 'DEVELOPMENT', 'Install latest version of Financial system', '5', 'DBMS upgrade will require latest version of Finance system for compatibility reasons', '3', '2008-12-19', '2008-12-22', '0', 'COMPLETED', '100', 'HIGH', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('3', '7', 'DEVELOPMENT', 'Switch to T3', 'Y', 'Physical switch date', '2', '2009-02-11', '2009-02-13', '0', 'COMPLETED', '100', 'MEDIUM', '4', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('4', '6', 'PLANINNG', 'Project Approval', 'Y', 'Project requires approval from upper management to move forward with plan', '0', '2008-12-06', '2008-12-06', '1087', 'COMPLETED', '100', 'LOW', '3', '', '2009-08-03', '2011-11-28', '0', '4', '', '2011-11-28'), ('5', '6', 'PLANINNG', 'Workstation purchase', '', 'Purchase 20 workstations', '12', '2008-12-13', '2008-12-25', '0', 'COMPLETED', '100', 'HIGH', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('6', '6', 'TEST', 'System test', '', 'Beta test system!', '3', '2009-02-14', '2009-02-17', '1179', 'COMPLETED', '100', 'LOW', '2', 'agora terminou', '2009-08-03', '2012-05-11', '0', '1', '', '2012-05-11'), ('7', '6', 'TEST', 'Total system conversion', '', 'System Conversion and/or rollback', '4', '2009-02-09', '2009-02-13', '1018', 'NOT-STARTED', '25', 'LOW', '1', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('8', '10', 'PLANINNG', 'Requirements review', '', 'Conduct requirements review with design team identify needs and wants', '4', '2009-02-05', '2009-02-09', '0', 'COMPLETED', '100', 'HIGH', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('9', '10', 'PLANINNG', 'Develop RFP', '', 'Developed RFP based  on client requirements', '2', '2009-02-05', '2009-02-07', '0', 'COMPLETED', '100', 'MEDIUM', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('10', '10', 'DEVELOPMENT', 'Install server side package', '', 'Install all server side components', '2', '2009-03-30', '2009-04-01', '971', 'NOT-STARTED', '0', 'MEDIUM', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('11', '10', 'TEST', 'Train engineering team on use and capability', '', 'Train the Design team on new system', '4', '2009-04-08', '2009-04-12', '960', 'NOT-STARTED', '0', 'LOW', '4', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('12', '8', 'PLANINNG', 'Meet with client team', 'Y', 'Need to meet with client team to understand current state of site and what is not working well.', '4', '2009-12-06', '2009-12-10', '0', 'COMPLETED', '100', 'MEDIUM', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('13', '8', 'DESIGN', 'Client review', '', 'Give client some time for review and feedback for chosen design', '2', '2009-01-16', '2009-01-18', '0', 'COMPLETED', '100', 'MEDIUM', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('14', '8', 'DEVELOPMENT', 'Revise based on feedback', '', 'Revise design based on feedback', '5', '2009-01-20', '2009-01-25', '1037', 'NOT-STARTED', '0', 'MEDIUM', '4', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('15', '8', 'DEVELOPMENT', 'Design 1', '', 'Present initial design to client', '3', '2009-01-23', '2009-01-26', '0', 'COMPLETED', '100', 'MEDIUM', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('16', '8', 'DEVELOPMENT', 'Deploy redesign', '', 'Deploy new design', '3', '2009-01-28', '2009-01-31', '0', 'COMPLETED', '100', 'LOW', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('17', '8', 'DESIGN', 'Propose site redesign', '', 'Propose three different approaches to solving problem and have client choose approach', '2', '2009-11-18', '2009-11-20', '738', 'NOT-STARTED', '0', 'MEDIUM', '4', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('18', '11', 'PLANINNG', 'Arrange switchover date', '', 'Set date for switchover', '3', '2009-11-04', '2009-11-07', '751', 'IN-PROGRESS', '15', 'MEDIUM', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('19', '11', 'PLANINNG', 'Follow-up w/ local vendor', '', 'Call T3 provider to arrange date and logistics', '4', '2009-11-09', '2009-11-13', '745', 'NOT-STARTED', '0', 'HIGH', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('20', '9', 'PLANINNG', 'End user feedback', '', 'Identify the specific end-user problem being solved with the wireless application. Identify and agree upon the functional elements of the end-users usage experience. Analyze and document the wireless application internal market opportunity .', '5', '2009-01-05', '2009-01-10', '0', 'COMPLETED', '100', 'HIGH', '1', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('21', '9', 'PLANINNG', 'ROI assessment', '', 'Identify the ROI and associated success factors. Communicate and gain buy-in from both senior management and the wireless project team. ', '6', '2009-01-09', '2009-01-15', '0', 'COMPLETED', '100', 'HIGH', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('22', '9', 'DEVELOPMENT', 'Deployment plan', '', 'Develop a deployment plan that includes: comprising device provisioning; network activation; application installation; usage tracking; bug tracking and upgrade procedures.', '4', '2009-01-23', '2009-01-27', '0', 'COMPLETED', '100', 'HIGH', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('23', '9', 'PLANINNG', 'Prototype', '', 'Evaluate both the storyboard and UI prototype by testing the prototype wireless application on a representative sample of intended end-users.', '4', '2009-01-25', '2009-01-29', '0', 'COMPLETED', '100', 'HIGH', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', '2009-08-03'), ('24', '9', 'DEVELOPMENT', 'Unit test', '', 'Unit test both the client-side and server-side components.', '30', '2009-02-03', '2009-03-05', '998', 'IN-PROGRESS', '65', 'MEDIUM', '1', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('25', '9', 'DEVELOPMENT', 'Network Topology design', '', 'The network topology is an exact duplicate of the existing system with exception of redundant servers', '2', '2009-03-08', '2009-03-10', '993', 'IN-PROGRESS', '0', 'LOW', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('26', '9', 'DEVELOPMENT', 'Alpha test', '', 'Perform at least 2 weeks of structured alpha testing with a group of 5 selected end-users.', '3', '2009-03-19', '2009-03-22', '981', 'NOT-STARTED', '0', 'MEDIUM', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('27', '9', 'DEVELOPMENT', 'Beta test', '', 'Perform at least 3 weeks of structured beta testing with a representative sample of end-users (usually 10%).', '5', '2009-03-04', '2009-03-09', '994', 'IN-PROGRESS', '0', 'MEDIUM', '1', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('28', '9', 'TEST', 'Post deployment', '', 'Post deployment; track usage of the various features of the wireless application.  Track ROI other variables and calculate actual project ROI.', '2', '2009-03-30', '2009-04-01', '971', 'NOT-STARTED', '0', 'LOW', '2', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('29', '9', 'DEVELOPMENT', 'Design applications', '', 'Design application s with a goal of maximizing reusability across all possible platforms.', '4', '2009-08-07', '2009-08-11', '839', 'IN-PROGRESS', '0', 'HIGH', '3', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('30', '9', 'DEVELOPMENT', 'Integration testing', '', 'Test the integrated solution in a structured format.', '14', '2009-09-02', '2009-09-16', '803', 'NOT-STARTED', '0', 'MEDIUM', '1', '', '2009-08-03', '2009-08-03', '0', '0', '', null), ('31', '12', 'DEVELOPMENT', 'Implement language indexes in main menu', 'Y', 'Implement language indexes in main menu', '2', '2009-09-16', '2009-09-18', '801', 'IN-PROGRESS', '0', 'HIGH', '1', 'Arlindo will verify this ', '2009-09-16', '2010-03-01', '2', '4', '', null);

-- ----------------------------
-- Table structure for `TaskStatus`
-- ----------------------------

create table `taskstatus` (
  `statusid` varchar(100) not null,
  `description` varchar(200) default null,
  primary key (`statusid`)
) engine=innodb default charset=utf8;

-- ----------------------------
-- Records of TaskStatus
-- ----------------------------
INSERT INTO `taskstatus` VALUES ('COMPLETED', 'Completed'), ('IN-PROGRESS', 'In progress'), ('NOT-STARTED', 'Not Started'), ('ON-HOLD', 'On Hold');


-- ----------------------------
-- Table structure for `TimeCard`
-- ----------------------------

create table `timecard` (
  `timecardid` int(11) not null auto_increment,
  `projectid` int(11) default null,
  `resourceid` int(10) default null,
  `weekstartingon` date default null,
  `sun` int(11) default null,
  `mon` int(11) default null,
  `tue` int(11) default null,
  `wed` int(11) default null,
  `thu` int(11) default null,
  `fri` int(11) default null,
  `sat` int(11) default null,
  `datecreated` date default null,
  `datemodified` date default null,
  `recordowner` int(11) default null,
  `lastmodifiedby` int(11) default null,
  primary key (`timecardid`),
  key `projectid` (`projectid`),
  key `resourceid` (`resourceid`),
  constraint `timecard_ibfk_1` foreign key (`projectid`) references `projects` (`projectid`),
  constraint `timecard_ibfk_2` foreign key (`resourceid`) references `resources` (`resourceid`)
) engine=innodb auto_increment=18 default charset=utf8;

-- ----------------------------
-- Records of TimeCard
-- ----------------------------
INSERT INTO `timecard` VALUES ('6', '6', '4', '2009-04-04', '0', '8', '8', '4', '8', '8', '3', '2009-08-03', '2009-08-03', '0', '0'), ('7', '6', '1', '2009-04-04', '0', '8', '8', '8', '2', '8', '0', '2009-08-03', '2009-08-03', '0', '0'), ('8', '10', '3', '2009-09-19', '0', '2', '8', '8', '4', '8', '0', '2009-08-03', '2009-08-03', '0', '0'), ('9', '10', '4', '2009-09-19', '0', '10', '8', '7', '6', '8', '0', '2009-08-03', '2009-08-03', '0', '0'), ('10', '10', '4', '2009-09-26', '0', '8', '8', '8', '8', '8', '0', '2009-08-03', '2009-08-03', '0', '0'), ('11', '8', '4', '2009-09-26', '0', '6', '8', '8', '4', '8', '0', '2009-08-03', '2009-08-03', '0', '0'), ('12', '11', '2', '2009-07-19', '0', '8', '8', '7', '8', '8', '3', '2009-08-03', '2009-08-03', '0', '0'), ('13', '11', '4', '2009-07-14', '0', '8', '8', '8', '2', '8', '10', '2009-08-03', '2009-08-03', '0', '0'), ('14', '12', '1', '2009-09-16', '0', '0', '0', '1', '0', '0', '0', '2009-09-16', '2009-09-16', '2', '2'), ('15', '6', '1', '2012-05-08', '0', '0', '0', '0', '0', '0', '0', '2012-05-11', '2012-05-11', '0', '0'), ('16', '6', '1', '2012-05-01', '0', '0', '0', '0', '0', '0', '0', '2012-05-11', '2012-05-11', '0', '0'), ('17', '6', '1', '2012-05-01', '0', '0', '0', '0', '0', '0', '0', '2012-05-11', '2012-05-11', '0', '0');

